<!-- Styler -->
<style type="text/css">
td, div {
	font-family: "Arial","​Helvetica","​sans-serif";
}
.datagrid-header-row * {
	font-weight: bold;
}
.messager-window * a:focus, .messager-window * span:focus {
	color: blue;
	font-weight: bold;
}
.daterangepicker * {
	font-family: "Source Sans Pro","Arial","​Helvetica","​sans-serif";
	box-sizing: border-box;
}
.glyphicon	{font-family: "Glyphicons Halflings"}
</style>

<?php 
	// buaat tanggal sekarang
	$tanggal = date('Y-m-d H:i');
	$tanggal_arr = explode(' ', $tanggal);
	$txt_tanggal = jin_date_ina($tanggal_arr[0]);
	$txt_tanggal .= ' - ' . $tanggal_arr[1];
?>

<!-- Data Grid -->
<table   id="dg" 
class="easyui-datagrid"
title="Data Transaksi Koin Non Depo / WD" 
style="width:auto; height: auto;" 
url="<?php echo site_url('pinjaman/ajax_list'); ?>" 
pagination="true" rownumbers="true" 
fitColumns="true" singleSelect="true" collapsible="true"
sortName="tgl_transaksi" sortOrder="desc"
toolbar="#tb"
striped="true">
<thead>
	<tr>
		<th data-options="field:'id', sortable:'true',halign:'center', align:'center'" hidden="true">ID</th>
		<th data-options="field:'id_txt', width:'10', halign:'center', align:'center'">Kode</th>
		<th data-options="field:'tgl_transaksi',halign:'center', align:'center'" hidden="true">Tanggal</th>
		<th data-options="field:'tgl_transaksi_txt', width:'15', halign:'center', align:'center'">Tanggal</th>
		<th data-options="field:'anggota_id',halign:'center', align:'center'" hidden="true">ID</th>
		<th data-options="field:'anggota_id_txt', width:'15', halign:'center', align:'center'" hidden="true">ID Anggota</th>
		<th data-options="field:'nama', width:'35',halign:'center', align:'left'" hidden="true">Nama Anggota</th>
		<th data-options="field:'departement', width:'15',halign:'center', align:'left'" hidden="true">Dept</th>
		<th data-options="field:'jenis_id',halign:'center', align:'center'" hidden="true">Jenis</th>
		<th data-options="field:'jenis_id_txt', width:'10', halign:'center', align:'center'">Status</th>
		<th data-options="field:'nama_penyetor', width:'20', halign:'center', align:'center'">Untuk Keperluan</th>
		<th data-options="field:'no_identitas', width:'10', halign:'center', align:'center'" hidden="true">Nama Rekening</th>
		<th data-options="field:'jumlah', width:'5', halign:'center', align:'right'" hidden="true">Nominal</th>
		<th data-options="field:'jumlahk', width:'5', halign:'center', align:'right'">Koin</th>
		<th data-options="field:'kas_id',halign:'center', align:'center'" hidden="true">Jenis Kas</th>
		<th data-options="field:'kas_id_txt', width:'10', halign:'center', align:'center'" hidden="true">Bank</th>
		<th data-options="field:'alamat',halign:'center', align:'center'" hidden="true">alamat</th>
		<th data-options="field:'user', width:'5', halign:'center', align:'center'">Operator</th>
		<th data-options="field:'ket', width:'10', halign:'center', align:'left'">Remark</th>
	</tr>
</thead>
</table>

<!-- Toolbar -->
<div id="tb" style="height: 55px;">
	<div style="vertical-align: middle; display: inline; padding-top: 15px;">
		<?php if($level == 'admin') { ?>
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="create()">Keluar</a>
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="update()">Keluar</a>		
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="hapus()">Hapus</a>
		<?php } ?>
	</div>
	<div class="pull-right" style="vertical-align: middle;">
		<div id="filter_tgl" class="input-group" style="display: inline;">
			<button class="btn btn-default" id="daterange-btn" style="line-height:16px;border:1px solid #ccc">
				<i class="fa fa-calendar"></i> <span id="reportrange"><span> Tanggal</span></span>
				<i class="fa fa-caret-down"></i>
			</button>
		</div>
		<select id="cari_simpanan2" name="cari_simpanan2" style="width:140px; height:27px" >
			<option value=""> -- Status -- </option>			
			<option value="201"> -- KOIN KELUAR -- </option>
			<option value="202"> -- KOIN MASUK -- </option>
		</select>
		<select id="cari_simpanan" name="cari_simpanan" style="width:140px; height:27px" >
			<option value=""> -- Untuk Keperluan -- </option>			
			<option value="-- ADJUSTMENT KOIN (KELUAR) --"> -- ADJUSTMENT KOIN (KELUAR) -- </option>
			<option value="-- REBATE --"> -- REBATE -- </option>
			<option value="-- ADJUSTMENT KOIN (MASUK) --"> -- ADJUSTMENT KOIN (MASUK) -- </option>
			<option value="-- TOP UP KOIN --"> -- TOP UP KOIN -- </option>
			<option value="-- LAST BALANCE KOIN --"> -- LAST BALANCE KOIN -- </option>
		</select>
		<span>Cari :</span>
		<input name="kode_transaksi" id="kode_transaksi" size="15" placeholder="[Remark]" style="line-height:21px;border:1px solid #ccc;">

		<a href="javascript:void(0);" id="btn_filter" class="easyui-linkbutton" iconCls="icon-search" plain="false" onclick="doSearch()">Cari</a>
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-print" plain="false" onclick="cetak()" style="display:none">Cetak</a>
		<a href="javascript:void(0);" class="easyui-linkbutton" iconCls="icon-clear" plain="false" onclick="clearSearch()">Hapus Filter</a>
	</div>
	<br>
	<div style="vertical-align: middle; display: inline; padding-top: 15px;">
		<?php if($level == 'admin') { ?>
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="create2()">Masuk </a>
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="update2()">Masuk </a>		
		<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="hapus()">Hapus</a>
		<?php } ?>
	</div>
</div>

<!-- Dialog Form -->
<div id="dialog-form" class="easyui-dialog" show= "blind" hide= "blind" modal="true" resizable="false" style="width:480px; height:400px; padding-left:20px; padding-top:20px; " closed="true" buttons="#dialog-buttons" style="display: none;">
	<form id="form" method="post" novalidate>
	<table style="height:200px" >
			<tr>
				<td>
					<table>
						<tr style="height:35px">
							<td>Tanggal Transaksi *</td>
							<td>:</td>
							<td>
								<div class="input-group date dtpicker col-md-5" style="z-index: 9999 !important;">
									<input type="text" name="tgl_transaksi_txt" id="tgl_transaksi_txt" style="width:150px; height:25px" required="true" readonly="readonly" />
									<input type="hidden" name="tgl_transaksi" id="tgl_transaksi" />
									<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
								</div>
							</td>	
						</tr>
						<tr style="height:35px">
							<td>Untuk Keperluan *</td>
							<td>:</td>
							<td>
								<select id="nama_penyetor" name="nama_penyetor" style="width:195px; height:25px" class="easyui-validatebox" required="true">
									<option value="-- ADJUSTMENT KOIN (KELUAR) --"> -- ADJUSTMENT KOIN (KELUAR) -- </option>
									<option value="-- REBATE --"> -- REBATE -- </option>
								</select>
							</td>
						</tr>
						<tr style="height:35px">
							<td>Jumlah Koin *</td>
							<td>:</td>
							<td>
								<input class="easyui-numberbox" id="jumlahk" name="jumlahk" data-options="precision:0,groupSeparator:',',decimalSeparator:'.'" class="easyui-validatebox" required="true" style="width:195px; height:25px"  />
							</td>	
						</tr>
						<tr style="height:35px">
							<td>Op Remark</td>
							<td>:</td>
							<td>
								<input id="ket" name="ket" style="width:190px; height:20px" >
							</td>	
						</tr>
						<tr style="height:100px">
							<td></td>
						</tr>
						<tr style="height:3px">
							<td><label for="type">(*) Harus diisi.</label></td>
						</tr>
				</table>
				</td>
			</tr>
		</table>
	</form>
</div>

<div id="dialog-form2" class="easyui-dialog" show= "blind" hide= "blind" modal="true" resizable="false" style="width:480px; height:400px; padding-left:20px; padding-top:20px; " closed="true" buttons="#dialog-buttons2" style="display: none;">
	<form id="form2" method="post" novalidate>
	<table style="height:200px" >
			<tr>
				<td>
					<table>
						<tr style="height:35px">
							<td>Tanggal Transaksi *</td>
							<td>:</td>
							<td>
								<div class="input-group date dtpicker col-md-5" style="z-index: 9999 !important;">
									<input type="text" name="tgl_transaksi_txt2" id="tgl_transaksi_txt2" style="width:150px; height:25px" required="true" readonly="readonly" />
									<input type="hidden" name="tgl_transaksi2" id="tgl_transaksi2" />
									<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
								</div>
							</td>	
						</tr>
						<tr style="height:35px">
							<td>Untuk Keperluan *</td>
							<td>:</td>
							<td>
								<select id="nama_penyetor" name="nama_penyetor" style="width:195px; height:25px" class="easyui-validatebox" required="true">
									<option value="-- ADJUSTMENT KOIN (MASUK) --"> -- ADJUSTMENT KOIN (MASUK) -- </option>
									<option value="-- TOP UP KOIN --"> -- TOP UP KOIN -- </option>
									<option value="-- LAST BALANCE KOIN --"> -- LAST BALANCE KOIN -- </option>
								</select>
							</td>
						</tr>
						<tr style="height:35px">
							<td>Jumlah Koin *</td>
							<td>:</td>
							<td>
								<input class="easyui-numberbox" id="jumlahk" name="jumlahk" data-options="precision:0,groupSeparator:',',decimalSeparator:'.'" class="easyui-validatebox" required="true" style="width:195px; height:25px"  />
							</td>	
						</tr>
						<tr style="height:35px">
							<td>Op Remark</td>
							<td>:</td>
							<td>
								<input id="ket" name="ket" style="width:190px; height:20px" >
							</td>	
						</tr>
						<tr style="height:100px">
							<td></td>
						</tr>
						<tr style="height:3px">
							<td><label for="type">(*) Harus diisi.</label></td>
						</tr>
				</table>
				</td>
			</tr>
		</table>
	</form>
</div>
<!-- Dialog Button -->
<div id="dialog-buttons">
	<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-ok" onclick="save()">Simpan</a>
	<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:jQuery('#dialog-form').dialog('close')">Batal</a>
</div>
<div id="dialog-buttons2">
	<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-ok" onclick="save2()">Simpan2</a>
	<a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:jQuery('#dialog-form2').dialog('close')">Batal2</a>
</div>

<script type="text/javascript">
$(document).ready(function() {
	$('#jenis_id').change(function(){
		val_jenis_id = $(this).val();
		$.ajax({
			url: '<?php echo site_url()?>pinjaman/get_jenis_simpanan',
			type: 'POST',
			dataType: 'html',
			data: {jenis_id: val_jenis_id},
		})
		.done(function(result) {
			$('#jumlah').numberbox('setValue', result);
			$('#jumlah ~ span input').focus();
			$('#jumlah ~ span input').select();	
		})
		.fail(function() {
			alert('Kesalahan Konekasi, silahkan ulangi beberapa saat lagi.');
		});		
	});

	$(".dtpicker").datetimepicker({
		language:  'id',
		weekStart: 1,
		autoclose: true,
		todayBtn: true,
		todayHighlight: true,
		pickerPosition: 'bottom-right',
		format: "dd MM yyyy - hh:ii",
		linkField: "tgl_transaksi",
		linkFormat: "yyyy-mm-dd hh:ii"
	});	

	$('#anggota_id').combogrid({
		panelWidth:400,
		url: '<?php echo site_url('pinjaman/list_anggota'); ?>',
		idField:'id',
		valueField:'id',
		textField:'nama',
		mode:'remote',
		fitColumns:true,
		columns:[[
		{field:'photo',title:'Photo',align:'center',width:5},
		{field:'id',title:'ID', hidden: true},
		{field:'kode_anggota', title:'ID', align:'center', width:15},
		{field:'nama',title:'Nama Anggota',align:'left',width:15},
		{field:'kota',title:'Kota',align:'left',width:10}
		]],
		onSelect: function(record){
			$("#anggota_poto").html('<img src="<?php echo base_url();?>assets/theme_admin/img/loading.gif" />');
			var val_anggota_id = $('input[name=anggota_id]').val();
			$.ajax({
				url: '<?php echo site_url(); ?>pinjaman/get_anggota_by_id/' + val_anggota_id,
				type: 'POST',
				dataType: 'html',
				data: {anggota_id: val_anggota_id},
			})
			.done(function(result) {
				$('#anggota_poto').html(result);
			})
			.fail(function() {
				alert('Koneksi error, silahkan ulangi.')
			});
		}
	});

	$("#cari_simpanan2").change(function(){
		$('#dg').datagrid('load',{
			cari_simpanan2: $('#cari_simpanan2').val()
		});
	});

	$("#cari_simpanan").change(function(){
		$('#dg').datagrid('load',{
			cari_simpanan: $('#cari_simpanan').val()
		});
	});

	$("#kode_transaksi").keyup(function(event){
		if(event.keyCode == 13){
			$("#btn_filter").click();
		}
	});

	$("#kode_transaksi").keyup(function(e){
		var isi = $(e.target).val();
		$(e.target).val(isi.toUpperCase());
	});

fm_filter_tgl();
}); // ready

function fm_filter_tgl() {
	$('#daterange-btn').daterangepicker({
		ranges: {
			'Hari ini': [moment(), moment()],
			'Kemarin': [moment().subtract('days', 1), moment().subtract('days', 1)],
			'7 Hari yang lalu': [moment().subtract('days', 6), moment()],
			'30 Hari yang lalu': [moment().subtract('days', 29), moment()],
			'Bulan ini': [moment().startOf('month'), moment().endOf('month')],
			'Bulan kemarin': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
			'Tahun ini': [moment().startOf('year').startOf('month'), moment().endOf('year').endOf('month')],
			'Tahun kemarin': [moment().subtract('year', 1).startOf('year').startOf('month'), moment().subtract('year', 1).endOf('year').endOf('month')]
		},
		showDropdowns: true,
		format: 'YYYY-MM-DD',
		startDate: moment().startOf('year').startOf('month'),
		endDate: moment().endOf('year').endOf('month')
	},

	function(start, end) {
		$('#reportrange span').html(start.format('D MMM YYYY') + ' - ' + end.format('D MMM YYYY'));
		doSearch();
	});
}
</script>

<script type="text/javascript">
var url;

function form_select_clear() {
	$('select option')
	.filter(function() {
		return !this.value || $.trim(this.value).length == 0;
	})
	.remove();
	$('select option')
	.first()
	.prop('selected', true);	
}

function doSearch(){
$('#dg').datagrid('load',{
	cari_simpanan2: $('#cari_simpanan2').val(),
	cari_simpanan: $('#cari_simpanan').val(),
	kode_transaksi: $('#kode_transaksi').val(),
	tgl_dari: 	$('input[name=daterangepicker_start]').val(),
	tgl_sampai: $('input[name=daterangepicker_end]').val()
});
}

function clearSearch(){
	location.reload();
}

function create(){
	$('#dialog-form').dialog('open').dialog('setTitle','Tambah Data Koin Keluar');
	$('#form').form('clear');
	$('#anggota_id ~ span span a').show();
	$('#anggota_id ~ span input').removeAttr('disabled');
	$('#anggota_id ~ span input').focus();
	
	$('#tgl_transaksi_txt').val('<?php echo $txt_tanggal;?>');
	$('#tgl_transaksi').val('<?php echo $tanggal;?>');
	$('#kas option[value="0"]').prop('selected', true);
	$('#jenis_id option[value="0"]').prop('selected', true);
	$("#anggota_poto").html('');
	$('#jumlah ~ span input').keyup(function(){
		var val_jumlah = $(this).val();
		$('#jumlah').numberbox('setValue', number_format(val_jumlah));
	});

	url = '<?php echo site_url('pinjaman/create'); ?>';
}

function create2(){
	$('#dialog-form2').dialog('open').dialog('setTitle','Tambah Data Koin Masuk');
	$('#form2').form('clear');
	$('#anggota_id ~ span span a').show();
	$('#anggota_id ~ span input').removeAttr('disabled');
	$('#anggota_id ~ span input').focus();
	
	$('#tgl_transaksi_txt2').val('<?php echo $txt_tanggal;?>');
	$('#tgl_transaksi2').val('<?php echo $tanggal;?>');
	$('#kas option[value="0"]').prop('selected', true);
	$('#jenis_id option[value="0"]').prop('selected', true);
	$("#anggota_poto").html('');
	$('#jumlah ~ span input').keyup(function(){
		var val_jumlah = $(this).val();
		$('#jumlah').numberbox('setValue', number_format(val_jumlah));
	});

	url = '<?php echo site_url('pinjaman/create2'); ?>';
}

function save() {
	var string = $("#form").serialize();
	//validasi teks kosong
	var jenis_id = $("#jenis_id").val();
	if(jenis_id == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Status belum dipilih.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#jenis_id").focus();
		return false;
	}

	var kas = $("#kas").val();
	if(kas == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Bank Tujuan belum dipilih.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#kas").focus();
		return false;
	}
	
	var nama_penyetor = $("#nama_penyetor").val();
	if(nama_penyetor == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, User ID belum diinput.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#nama_penyetor").focus();
		return false;
	}

	var no_identitas = $("#no_identitas").val();
	if(no_identitas == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, No Rek / HP belum diinput.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#no_identitas").focus();
		return false;
	}

	var isValid = $('#form').form('validate');
	if (isValid) {
		$.ajax({
			type	: "POST",
			url: url,
			data	: string,
			success	: function(result){
				var result = eval('('+result+')');
				$.messager.show({
					title:'<div><i class="fa fa-info"></i> Informasi</div>',
					msg: result.msg,
					timeout:2000,
					showType:'slide'
				});
				if(result.ok) {
					jQuery('#dialog-form').dialog('close');
					//clearSearch();
					$('#dg').datagrid('reload');
				}
			}
		});
	} else {
		$.messager.show({
			title:'<div><i class="fa fa-info"></i> Informasi</div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Lengkapi seluruh pengisian data.</div>',
			timeout:2000,
			showType:'slide'
		});
	}
}

function save2() {
	var string = $("#form2").serialize();
	//validasi teks kosong
	var jenis_id = $("#jenis_id").val();
	if(jenis_id == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Status belum dipilih.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#jenis_id").focus();
		return false;
	}

	var kas = $("#kas").val();
	if(kas == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Bank Tujuan belum dipilih.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#kas").focus();
		return false;
	}
	
	var nama_penyetor = $("#nama_penyetor").val();
	if(nama_penyetor == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, User ID belum diinput.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#nama_penyetor").focus();
		return false;
	}

	var no_identitas = $("#no_identitas").val();
	if(no_identitas == 0) {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan ! </div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, No Rek / HP belum diinput.</div>',
			timeout:4000,
			showType:'slide'
		});
		$("#no_identitas").focus();
		return false;
	}

	var isValid = $('#form2').form('validate');
	if (isValid) {
		$.ajax({
			type	: "POST",
			url: url,
			data	: string,
			success	: function(result){
				var result = eval('('+result+')');
				$.messager.show({
					title:'<div><i class="fa fa-info"></i> Informasi</div>',
					msg: result.msg,
					timeout:2000,
					showType:'slide'
				});
				if(result.ok) {
					jQuery('#dialog-form2').dialog('close');
					//clearSearch();
					$('#dg').datagrid('reload');
				}
			}
		});
	} else {
		$.messager.show({
			title:'<div><i class="fa fa-info"></i> Informasi</div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Lengkapi seluruh pengisian data.</div>',
			timeout:2000,
			showType:'slide'
		});
	}
}

function update(){
	var row = jQuery('#dg').datagrid('getSelected');
	if(row){
		jQuery('#dialog-form').dialog('open').dialog('setTitle','Edit Data Setoran');
		jQuery('#form').form('load',row);
		$('#anggota_id ~ span input').attr('disabled', true);
		$('#anggota_id ~ span input').css('background-color', '#fff');
		$('#anggota_id ~ span span a').hide();
		url = '<?php echo site_url('pinjaman/update'); ?>/' + row.id;
		$('#jumlah ~ span input').keyup(function(){
			var val_jumlah = $(this).val();
			$('#jumlah').numberbox('setValue', number_format(val_jumlah));
		});
		
	}else {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan !</div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Data harus dipilih terlebih dahulu </div>',
			timeout:2000,
			showType:'slide'
		});
	}
}

function update2(){
	var row = jQuery('#dg').datagrid('getSelected');
	if(row){
		jQuery('#dialog-form2').dialog('open').dialog('setTitle','Edit Data Setoran');
		jQuery('#form2').form('load',row);
		$('#anggota_id ~ span input').attr('disabled', true);
		$('#anggota_id ~ span input').css('background-color', '#fff');
		$('#anggota_id ~ span span a').hide();
		url = '<?php echo site_url('pinjaman/update2'); ?>/' + row.id;
		$('#jumlah ~ span input').keyup(function(){
			var val_jumlah = $(this).val();
			$('#jumlah').numberbox('setValue', number_format(val_jumlah));
		});
		
	}else {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan !</div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Data harus dipilih terlebih dahulu </div>',
			timeout:2000,
			showType:'slide'
		});
	}
}

function hapus(){  
	var row = $('#dg').datagrid('getSelected');  
	if (row){ 
		$.messager.confirm('Konfirmasi','Apakah Anda akan menghapus data kode transaksi : <code>' + row.id_txt + '</code> ?',function(r){  
			if (r){  
				$.ajax({
					type	: "POST",
					url		: "<?php echo site_url('pinjaman/delete'); ?>",
					data	: 'id='+row.id,
					success	: function(result){
						var result = eval('('+result+')');
						$.messager.show({
							title:'<div><i class="fa fa-info"></i> Informasi</div>',
							msg: result.msg,
							timeout:2000,
							showType:'slide'
						});
						if(result.ok) {
							$('#dg').datagrid('reload');
						}
					},
					error : function (){
						$.messager.show({
							title:'<div><i class="fa fa-warning"></i> Peringatan !</div>',
							msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Terjadi kesalahan koneksi, silahkan muat ulang !</div>',
							timeout:2000,
							showType:'slide'
						});
					}
				});  
			}  
		}); 
	}  else {
		$.messager.show({
			title:'<div><i class="fa fa-warning"></i> Peringatan !</div>',
			msg: '<div class="text-red"><i class="fa fa-ban"></i> Maaf, Data harus dipilih terlebih dahulu </div>',
			timeout:2000,
			showType:'slide'
		});	
	}
	$('.messager-button a:last').focus();
}

function cetak () {
	var cari_simpanan2 	= $('#cari_simpanan2').val();
	var cari_simpanan 	= $('#cari_simpanan').val();
	var kode_transaksi 	= $('#kode_transaksi').val();
	var tgl_dari			= $('input[name=daterangepicker_start]').val();
	var tgl_sampai			= $('input[name=daterangepicker_end]').val();
	
	var win = window.open('<?php echo site_url("pinjaman/cetak_laporan/?cari_simpanan2=' + cari_simpanan2 + '&cari_simpanan=' + cari_simpanan + '&kode_transaksi=' + kode_transaksi + '&tgl_dari=' + tgl_dari + '&tgl_sampai=' + tgl_sampai + '"); ?>');
	if (win) {
		win.focus();
	} else {
		alert('Popup jangan di block');
	}
}
</script>

